import numpy as np
import networkx as nx
import pickle as pkl
import os

filename = "ground_truth"
filepath = os.path.join(os.getcwd(), "src", "data", "dataset0")
graph = nx.read_graphml(os.path.join(filepath, f"{filename}.gml"))

# Convert the graph to a numpy array
adj_matrix = nx.to_numpy_array(graph)

# Save the numpy array as an npz file
np.savetxt(os.path.join(filepath, f"{filename}.npz"), adj_matrix, delimiter=',')